%This program is used to estimate the variance function.
%x0 is a vector. The variance function will be estimated on those points.
%n is the number of subjects
%N is the number of replication
%savfile is the address for saving the variance function
function mv=estmate_quality_mv(x0,n,N,savfile)%x0 is a vector
L=length(x0);
Len=length(savfile);
%J=str2num(savfile(12:Len));
m=textread(['m_00n_',num2str(n),'J_',num2str(J),'1000.txt']);
str='%7.3f';
for i=1:L-1
str=[str ' %7.3f'];
end
str= [str '\n'];
for j=1:N
% get raw data which are generated by using the codes in the raw data code and compute the square
%residuals as the new data for estiamting the variance function
 [y,x]=getdata(n,j,['C:\2012-06-20\2012-06-20-1\2012-06-20-1\U of M\quality\rawdataic_for_univariate_spc_', num2str(L)],savfile,L);
 J=length(x(:,1));
 for kk=1:J
     y(kk,:)=(y(kk,:)-m(j,round(L.*x(kk,:)))).^2;
 end

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%compute the initial estimator of mean function by using local linear kernel method (LK)
% the Cross_V_LK is for selecting bandwidth by using the CV method based on Lk.
% t=0;
% for h1=0.05:0.05:1
%         t=t+1;
%       cv(t)=Cross_V_LK(x,y,h1);
% end
%   [aa,bb]=min(cv);
%   h1=bb*0.05;
h1=0.4;
 for i=1:L
    mlk(1,i)=LK(x0(i),x,y,h1);
 end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%compute the initial estimator of variance function by using local linear kernel method (LK)
% the Cross_V_LK is for selecting bandwidth by using the CV method based on Lk.
for kk=1:J
     yv(kk,:)=(y(kk,:)-mlk(1,round(L.*x(kk,:)))).^2;
end
% t=0;
% for h2=0.05:0.05:1
%         t=t+1;
%       cv(t)=Cross_V_LK(x,yv,h2);
% end
%   [aa,bb]=min(cv);
%   h2=bb*0.05;
h2=0.4;  
  for i=1:L
    mlkv(1,i)=LK(x0(i),x,yv,h2);
  end
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%compute the initial estimator of covariance function by using Li's (2011) method (LK)
% the Cross_V_LK_Li is for selecting bandwidth by using the CV method based on Li (2011)
  for kk=1:J
     ev(kk,:)=y(kk,:)-mlk(1,round(L.*x(kk,:)));
  end
  
% t=0;
% for h3=0.05:0.05:1
%         t=t+1;
%       cv(t)=Cross_V_LK_Li(x,ev,h3);
% end
%   [aa,bb]=min(cv);
%   h3=bb*0.05;
h3=0.05;  
  for i=1:L
      for j=1:L
          if i~=j
    mlk_Liv(i,j)=0;%LK_Li(x0(i),x0(j),x,ev,h3);
          end
      end
  end
  V=diag(mlkv)+mlk_Liv;

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%compute the updated estimator of variance function by using our proposed method.
% the Cross_V_EM is for selecting bandwidth by using the CV method based on our
% proposed method.
 for i=1:n
     r(:,:,i)=V(round(L.*x(:,i)),round(L.*x(:,i)));
 end
 
% t=0;
% for h4=0.05:0.05:1
%         t=t+1;
%       cv(t)=Cross_V_EM(x,ev,h4);
% end
%   [aa,bb]=min(cv);
%   h4=bb*0.05; 
 h4=0.3;
for i=1:L
    m(1,i)=Estimate_1_i(x0(i),x,y,h4,r);
end
% save the results
fid2=fopen([savfile,'var.txt'],'a');
fprintf(fid2,str,mv(:,:)');
fclose(fid2);
end
